#property copyright "Copyright  2007, FX Instructor, LLC"
#property link      "http://www.fxinstructor.com"

#property indicator_chart_window
#property indicator_buffers 7
#property indicator_color1 Black
#property indicator_color2 Black
#property indicator_color3 Black
#property indicator_color4 Black
#property indicator_color5 Black
#property indicator_color6 Black
#property indicator_color7 Black

extern int maxWeeks = 3;
extern bool weeklyNotDaily = FALSE;
extern bool showPivotLines = TRUE;
extern bool showPivotLabels = TRUE;
extern bool showPivotIcons = FALSE;
extern int pivotThickness = 0;
extern int pivotFontSize = 8;
extern string pivotFont = "Arial";

extern color R3Color = Red;
extern color R2Color = Coral;
extern color R1Color = C'253,175,147';
extern color PColor  = C'30,160,0';
extern color S1Color = C'162,192,246';
extern color S2Color = CornflowerBlue;
extern color S3Color = Blue;

double G_ibuf_140[];
double G_ibuf_144[];
double G_ibuf_148[];
double G_ibuf_152[];
double G_ibuf_156[];
double G_ibuf_160[];
double G_ibuf_164[];
double Gd_168;
double Gd_176;
double Gd_184;
double Gd_192;
double Gd_200;
double Gd_208;
double Gd_216;
int Gi_256 = 0;
int G_digits_260;

int init() {
   string Ls_0;
   int style_8;
   G_digits_260 = MarketInfo(Symbol(), MODE_DIGITS);
   IndicatorDigits(G_digits_260);
   if (weeklyNotDaily) {
      style_8 = 2;
      Ls_0 = "Week";
      IndicatorShortName("FXI Weekly Pivots");
   } else {
      style_8 = 0;
      Ls_0 = "Day";
      IndicatorShortName("FXI Daily Pivots");
   }
   if (showPivotLines) {
      SetIndexBuffer(0, G_ibuf_148);
      SetIndexLabel(0, "R3 " + Ls_0);
      SetIndexStyle(0, DRAW_LINE, style_8, pivotThickness, R3Color);
      SetIndexArrow(0, 160);
      SetIndexBuffer(1, G_ibuf_144);
      SetIndexLabel(1, "R2 " + Ls_0);
      SetIndexStyle(1, DRAW_LINE, style_8, pivotThickness, R2Color);
      SetIndexArrow(1, 160);
      SetIndexBuffer(2, G_ibuf_140);
      SetIndexLabel(2, "R1 " + Ls_0);
      SetIndexStyle(2, DRAW_LINE, style_8, pivotThickness, R1Color);
      SetIndexArrow(2, 160);
      SetIndexBuffer(3, G_ibuf_152);
      SetIndexLabel(3, "P " + Ls_0);
      SetIndexStyle(3, DRAW_LINE, style_8, pivotThickness, PColor);
      SetIndexArrow(3, 160);
      SetIndexBuffer(4, G_ibuf_156);
      SetIndexLabel(4, "S1 " + Ls_0);
      SetIndexStyle(4, DRAW_LINE, style_8, pivotThickness, S1Color);
      SetIndexArrow(4, 160);
      SetIndexBuffer(5, G_ibuf_160);
      SetIndexLabel(5, "S2 " + Ls_0);
      SetIndexStyle(5, DRAW_LINE, style_8, pivotThickness, S2Color);
      SetIndexArrow(5, 160);
      SetIndexBuffer(6, G_ibuf_164);
      SetIndexLabel(6, "S3 " + Ls_0);
      SetIndexStyle(6, DRAW_LINE, style_8, pivotThickness, S3Color);
      SetIndexArrow(6, 160);
   }
   return (0);
}
	    	 	 		 	    	   				    					      	  	 	  		  			  					 	    	 	  	   	 	    	 		   	 	    	 			           	 	  	 		 			 				    			  		 	
int deinit() {
   int Li_0;
   if (weeklyNotDaily) Li_0 = maxWeeks;
   else Li_0 = 5 * maxWeeks;
   for (int Li_4 = 1; Li_4 <= Li_0; Li_4++) clearBars(Li_4);
   return (0);
}
	 		  				 				 				   	  		   	 			 		   	   	  				   		  	 			 				  				  			 				 		 	   	 	  		   	 		 		 	  							 		    	   		  	 	     
int start() {
   int Li_0;
   int ind_counted_4 = IndicatorCounted();
   if (weeklyNotDaily) Li_0 = maxWeeks;
   else Li_0 = 5 * maxWeeks;
   for (int Li_8 = Li_0; Li_8 > 0; Li_8--) doPivots(Li_8);
   return (0);
}
		  			 	 	   			   		   	  		      	 		 	 					     	 		 		 		 		     		   			 		      		 								  	 			  	 					   	 	 	  	 	  			 		  	 		 	 
void doPivots(int Ai_0) {
   int timeframe_4;
   int datetime_8;
   if (weeklyNotDaily) timeframe_4 = 10080;
   else {
      timeframe_4 = 1440;
      datetime_8 = iTime(NULL, timeframe_4, Ai_0);
   }
   if (!(!weeklyNotDaily) || !(TimeDayOfWeek(datetime_8) < 1 || TimeDayOfWeek(datetime_8) > 5)) {
      Gd_168 = getP(Ai_0, timeframe_4);
      Gd_176 = getR1(Ai_0, timeframe_4);
      Gd_184 = getR2(Ai_0, timeframe_4);
      Gd_192 = getR3(Ai_0, timeframe_4);
      Gd_200 = getS1(Ai_0, timeframe_4);
      Gd_208 = getS2(Ai_0, timeframe_4);
      Gd_216 = getS3(Ai_0, timeframe_4);
      if (showPivotLabels) drawPivotLabels(Ai_0, timeframe_4);
      if (showPivotIcons) drawPivotIcons(Ai_0, timeframe_4);
   }
   if (showPivotLines) drawPivotLines(Ai_0, timeframe_4);
}
	 	  	   	  	  	 		  		 	 	  		 			    		 		 	 				 				 	 			    	 	 		 		  	    	 	 	   		 	 	    				  	    	    	    	  						 	   			   				
double getP(int Ai_0, int A_timeframe_4) {
   double ihigh_8 = iHigh(Symbol(), A_timeframe_4, Ai_0);
   double ilow_16 = iLow(Symbol(), A_timeframe_4, Ai_0);
   double iclose_24 = iClose(Symbol(), A_timeframe_4, Ai_0);
   double Ld_ret_32 = (ihigh_8 + ilow_16 + iclose_24) / 3.0;
   return (Ld_ret_32);
}
						  	  	   		 					  						   			  	 		 		 	  		 				    	  				  			 				  				  	 			 		 			 	 								  			 	    	  	 			    	  	   					 
double getS1(int Ai_0, int A_timeframe_4) {
   double ihigh_8 = iHigh(Symbol(), A_timeframe_4, Ai_0);
   double Ld_16 = Gd_168;
   double Ld_ret_24 = 2.0 * Ld_16 - ihigh_8;
   return (Ld_ret_24);
}
		  			 	 	   			   		   	  		      	 		 	 					     	 		 		 		 		     		   			 		      		 								  	 			  	 					   	 	 	  	 	  			 		  	 		 	 
double getR1(int Ai_0, int A_timeframe_4) {
   double ilow_8 = iLow(Symbol(), A_timeframe_4, Ai_0);
   double Ld_16 = Gd_168;
   double Ld_ret_24 = 2.0 * Ld_16 - ilow_8;
   return (Ld_ret_24);
}
			  			    	 	   	  	 				  	 		 	   	 				 		 	 	 		     					 		 	     	  			 		 	  	 			 		  	  		   		   	  	  	 		    		  	  	  	 	    	  	
double getS2(int Ai_0, int A_timeframe_4) {
   double ihigh_8 = iHigh(Symbol(), A_timeframe_4, Ai_0);
   double ilow_16 = iLow(Symbol(), A_timeframe_4, Ai_0);
   double Ld_24 = Gd_168;
   double Ld_ret_32 = Ld_24 - (ihigh_8 - ilow_16);
   return (Ld_ret_32);
}
		  				  	   	     		 			  		 		   	 	 		 				 	    	    		 			 	          				 	     	 	 				  		  	   	  	 	  		   		  	  	  	 			 	 	 	 		  	
double getR2(int Ai_0, int A_timeframe_4) {
   double ihigh_8 = iHigh(Symbol(), A_timeframe_4, Ai_0);
   double ilow_16 = iLow(Symbol(), A_timeframe_4, Ai_0);
   double Ld_24 = Gd_168;
   double Ld_ret_32 = Ld_24 + (ihigh_8 - ilow_16);
   return (Ld_ret_32);
}
		  			   	   		    		  		  		  	   	 				 						    	 	  		 		  	     	    			  	       	 					 		  	 	 	  	 		 		   	   	  	 		 			 			 	 		 		
double getS3(int Ai_0, int A_timeframe_4) {
   double ihigh_8 = iHigh(Symbol(), A_timeframe_4, Ai_0);
   double ilow_16 = iLow(Symbol(), A_timeframe_4, Ai_0);
   double Ld_24 = Gd_168;
   double Ld_ret_32 = ilow_16 - 2.0 * (ihigh_8 - Ld_24);
   return (Ld_ret_32);
}
	   			  		   		 	  		  	   		  		  	 			  							   	 	 			 		        	 	  			            					  	  	 	    	 		  	   	  		  	 						 					 		 		
double getR3(int Ai_0, int A_timeframe_4) {
   double ihigh_8 = iHigh(Symbol(), A_timeframe_4, Ai_0);
   double ilow_16 = iLow(Symbol(), A_timeframe_4, Ai_0);
   double Ld_24 = Gd_168;
   double Ld_ret_32 = ihigh_8 + 2.0 * (Ld_24 - ilow_16);
   return (Ld_ret_32);
}
	 				  		 	   								   					  				  	  	 		 	 			 					   	  	 		  								  	 		  	 	 	 		 		  	 				 			  		  	    		 	 			 	  	  	 	 					 
void drawPivotIcons(int Ai_0, int A_timeframe_4) {
   string Ls_12;
   int datetime_8 = iTime(Symbol(), A_timeframe_4, Ai_0 - 1);
   if (weeklyNotDaily) Ls_12 = "Week";
   else Ls_12 = "Day";
   if (ObjectFind("R1 " + Ls_12 + " Icon " + Ai_0) == -1) {
      ObjectCreate("R1 " + Ls_12 + " Icon " + Ai_0, OBJ_ARROW, 0, datetime_8, Gd_176 + Point * Gi_256);
      ObjectSet("R1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_ARROWCODE, 140);
      ObjectSet("R1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_WIDTH, pivotThickness + 1);
      ObjectSet("R1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_COLOR, R1Color);
   } else {
      ObjectSet("R1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("R1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_PRICE1, Gd_176 + Point * Gi_256);
   }
   if (ObjectFind("R2 " + Ls_12 + " Icon " + Ai_0) == -1) {
      ObjectCreate("R2 " + Ls_12 + " Icon " + Ai_0, OBJ_ARROW, 0, datetime_8, Gd_184 + Point * Gi_256);
      ObjectSet("R2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_ARROWCODE, 141);
      ObjectSet("R2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_WIDTH, pivotThickness + 1);
      ObjectSet("R2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_COLOR, R2Color);
   } else {
      ObjectSet("R2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("R2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_PRICE1, Gd_184 + Point * Gi_256);
   }
   if (ObjectFind("R3 " + Ls_12 + " Icon " + Ai_0) == -1) {
      ObjectCreate("R3 " + Ls_12 + " Icon " + Ai_0, OBJ_ARROW, 0, datetime_8, Gd_192 + Point * Gi_256);
      ObjectSet("R3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_ARROWCODE, 142);
      ObjectSet("R3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_WIDTH, pivotThickness + 1);
      ObjectSet("R3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_COLOR, R3Color);
   } else {
      ObjectSet("R3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("R3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_PRICE1, Gd_192 + Point * Gi_256);
   }
   if (ObjectFind("P " + Ls_12 + " Icon " + Ai_0) == -1) {
      ObjectCreate("P " + Ls_12 + " Icon " + Ai_0, OBJ_ARROW, 0, datetime_8, Gd_168 + Point * Gi_256);
      ObjectSet("P " + Ls_12 + " Icon " + Ai_0, OBJPROP_ARROWCODE, 164);
      ObjectSet("P " + Ls_12 + " Icon " + Ai_0, OBJPROP_WIDTH, pivotThickness + 1);
      ObjectSet("P " + Ls_12 + " Icon " + Ai_0, OBJPROP_COLOR, PColor);
   } else {
      ObjectSet("P " + Ls_12 + " Icon " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("P " + Ls_12 + " Icon " + Ai_0, OBJPROP_PRICE1, Gd_168 + Point * Gi_256);
   }
   if (ObjectFind("S1 " + Ls_12 + " Icon " + Ai_0) == -1) {
      ObjectCreate("S1 " + Ls_12 + " Icon " + Ai_0, OBJ_ARROW, 0, datetime_8, Gd_200 + Point * Gi_256);
      ObjectSet("S1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_ARROWCODE, 129);
      ObjectSet("S1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_WIDTH, pivotThickness + 1);
      ObjectSet("S1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_COLOR, S1Color);
   } else {
      ObjectSet("S1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("S1 " + Ls_12 + " Icon " + Ai_0, OBJPROP_PRICE1, Gd_200 + Point * Gi_256);
   }
   if (ObjectFind("S2 " + Ls_12 + " Icon " + Ai_0) == -1) {
      ObjectCreate("S2 " + Ls_12 + " Icon " + Ai_0, OBJ_ARROW, 0, datetime_8, Gd_208 + Point * Gi_256);
      ObjectSet("S2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_ARROWCODE, 130);
      ObjectSet("S2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_WIDTH, pivotThickness + 1);
      ObjectSet("S2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_COLOR, S2Color);
   } else {
      ObjectSet("S2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("S2 " + Ls_12 + " Icon " + Ai_0, OBJPROP_PRICE1, Gd_208 + Point * Gi_256);
   }
   if (ObjectFind("S3 " + Ls_12 + " Icon " + Ai_0) == -1) {
      ObjectCreate("S3 " + Ls_12 + " Icon " + Ai_0, OBJ_ARROW, 0, datetime_8, Gd_216 + Point * Gi_256);
      ObjectSet("S3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_ARROWCODE, 131);
      ObjectSet("S3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_WIDTH, pivotThickness + 1);
      ObjectSet("S3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_COLOR, S3Color);
      return;
   }
   ObjectSet("S3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_TIME1, datetime_8);
   ObjectSet("S3 " + Ls_12 + " Icon " + Ai_0, OBJPROP_PRICE1, Gd_216 + Point * Gi_256);
}
	  	 	  					  			 	 		    	 		  	 	   	     	 	 	 								 		  	  		 				 	 	  	  		 	 	    	 		 							  	   		 			   								 		    	 			 			 
void drawPivotLines(int Ai_0, int A_timeframe_4) {
   int Li_8 = iBarShift(Symbol(), 0, iTime(Symbol(), A_timeframe_4, Ai_0 - 1));
   int shift_12 = iBarShift(Symbol(), 0, iTime(Symbol(), A_timeframe_4, Ai_0 - 2));
   if (Ai_0 == 1) shift_12 = 0;
   for (int Li_16 = Li_8; Li_16 >= shift_12; Li_16--) {
      G_ibuf_152[Li_16] = Gd_168;
      G_ibuf_140[Li_16] = Gd_176;
      G_ibuf_144[Li_16] = Gd_184;
      G_ibuf_148[Li_16] = Gd_192;
      G_ibuf_156[Li_16] = Gd_200;
      G_ibuf_160[Li_16] = Gd_208;
      G_ibuf_164[Li_16] = Gd_216;
   }
}
	    						 	 	 		   	 	     	 	 	    	    	 		  	  		  									   	   		   				   	  		  	 		 	 	 		  	     	 	 	 	 					 		   			  	  		  	   
void drawPivotLabels(int Ai_0, int A_timeframe_4) {
   string Ls_12;
   int datetime_8 = iTime(Symbol(), A_timeframe_4, Ai_0 - 1);
   if (weeklyNotDaily) Ls_12 = "Week";
   else Ls_12 = "Day";
   if (ObjectFind("R1 " + Ls_12 + " Label " + Ai_0) == -1) {
      ObjectCreate("R1 " + Ls_12 + " Label " + Ai_0, OBJ_TEXT, 0, datetime_8, Gd_176 + Point * Gi_256);
      ObjectSet("R1 " + Ls_12 + " Label " + Ai_0, OBJPROP_WIDTH, pivotThickness);
      ObjectSet("R1 " + Ls_12 + " Label " + Ai_0, OBJPROP_COLOR, R1Color);
   } else {
      ObjectSet("R1 " + Ls_12 + " Label " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("R1 " + Ls_12 + " Label " + Ai_0, OBJPROP_PRICE1, Gd_176 + Point * Gi_256);
   }
   ObjectSetText("R1 " + Ls_12 + " Label " + Ai_0, "R1 " + Ls_12 + ": " + DoubleToStr(Gd_176, G_digits_260), pivotFontSize, pivotFont, R1Color);
   if (ObjectFind("R2 " + Ls_12 + " Label " + Ai_0) == -1) {
      ObjectCreate("R2 " + Ls_12 + " Label " + Ai_0, OBJ_TEXT, 0, datetime_8, Gd_184 + Point * Gi_256);
      ObjectSet("R2 " + Ls_12 + " Label " + Ai_0, OBJPROP_WIDTH, pivotThickness);
      ObjectSet("R2 " + Ls_12 + " Label " + Ai_0, OBJPROP_COLOR, R2Color);
   } else {
      ObjectSet("R2 " + Ls_12 + " Label " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("R2 " + Ls_12 + " Label " + Ai_0, OBJPROP_PRICE1, Gd_184 + Point * Gi_256);
   }
   ObjectSetText("R2 " + Ls_12 + " Label " + Ai_0, "R2 " + Ls_12 + ": " + DoubleToStr(Gd_184, G_digits_260), pivotFontSize, pivotFont, R2Color);
   if (ObjectFind("R3 " + Ls_12 + " Label " + Ai_0) == -1) {
      ObjectCreate("R3 " + Ls_12 + " Label " + Ai_0, OBJ_TEXT, 0, datetime_8, Gd_192 + Point * Gi_256);
      ObjectSet("R3 " + Ls_12 + " Label " + Ai_0, OBJPROP_WIDTH, pivotThickness);
      ObjectSet("R3 " + Ls_12 + " Label " + Ai_0, OBJPROP_COLOR, R3Color);
   } else {
      ObjectSet("R3 " + Ls_12 + " Label " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("R3 " + Ls_12 + " Label " + Ai_0, OBJPROP_PRICE1, Gd_192 + Point * Gi_256);
   }
   ObjectSetText("R3 " + Ls_12 + " Label " + Ai_0, "R3 " + Ls_12 + ": " + DoubleToStr(Gd_192, G_digits_260), pivotFontSize, pivotFont, R3Color);
   if (ObjectFind("P " + Ls_12 + " Label " + Ai_0) == -1) {
      ObjectCreate("P " + Ls_12 + " Label " + Ai_0, OBJ_TEXT, 0, datetime_8, Gd_168 + Point * Gi_256);
      ObjectSet("P " + Ls_12 + " Label " + Ai_0, OBJPROP_WIDTH, pivotThickness);
      ObjectSet("P " + Ls_12 + " Label " + Ai_0, OBJPROP_COLOR, PColor);
   } else {
      ObjectSet("P " + Ls_12 + " Label " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("P " + Ls_12 + " Label " + Ai_0, OBJPROP_PRICE1, Gd_168 + Point * Gi_256);
   }
   ObjectSetText("P " + Ls_12 + " Label " + Ai_0, "P " + Ls_12 + ": " + DoubleToStr(Gd_168, G_digits_260), pivotFontSize, pivotFont, PColor);
   if (ObjectFind("S1 " + Ls_12 + " Label " + Ai_0) == -1) {
      ObjectCreate("S1 " + Ls_12 + " Label " + Ai_0, OBJ_TEXT, 0, datetime_8, Gd_200 + Point * Gi_256);
      ObjectSet("S1 " + Ls_12 + " Label " + Ai_0, OBJPROP_WIDTH, pivotThickness);
      ObjectSet("S1 " + Ls_12 + " Label " + Ai_0, OBJPROP_COLOR, S1Color);
   } else {
      ObjectSet("S1 " + Ls_12 + " Label " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("S1 " + Ls_12 + " Label " + Ai_0, OBJPROP_PRICE1, Gd_200 + Point * Gi_256);
   }
   ObjectSetText("S1 " + Ls_12 + " Label " + Ai_0, "S1 " + Ls_12 + ": " + DoubleToStr(Gd_200, G_digits_260), pivotFontSize, pivotFont, S1Color);
   if (ObjectFind("S2 " + Ls_12 + " Label " + Ai_0) == -1) {
      ObjectCreate("S2 " + Ls_12 + " Label " + Ai_0, OBJ_TEXT, 0, datetime_8, Gd_208 + Point * Gi_256);
      ObjectSet("S2 " + Ls_12 + " Label " + Ai_0, OBJPROP_WIDTH, pivotThickness);
      ObjectSet("S2 " + Ls_12 + " Label " + Ai_0, OBJPROP_COLOR, S2Color);
   } else {
      ObjectSet("S2 " + Ls_12 + " Label " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("S2 " + Ls_12 + " Label " + Ai_0, OBJPROP_PRICE1, Gd_208 + Point * Gi_256);
   }
   ObjectSetText("S2 " + Ls_12 + " Label " + Ai_0, "S2 " + Ls_12 + ": " + DoubleToStr(Gd_208, G_digits_260), pivotFontSize, pivotFont, S2Color);
   if (ObjectFind("S3 " + Ls_12 + " Label " + Ai_0) == -1) {
      ObjectCreate("S3 " + Ls_12 + " Label " + Ai_0, OBJ_TEXT, 0, datetime_8, Gd_216 + Point * Gi_256);
      ObjectSet("S3 " + Ls_12 + " Label " + Ai_0, OBJPROP_WIDTH, pivotThickness);
      ObjectSet("S3 " + Ls_12 + " Label " + Ai_0, OBJPROP_COLOR, S3Color);
   } else {
      ObjectSet("S3 " + Ls_12 + " Label " + Ai_0, OBJPROP_TIME1, datetime_8);
      ObjectSet("S3 " + Ls_12 + " Label " + Ai_0, OBJPROP_PRICE1, Gd_216 + Point * Gi_256);
   }
   ObjectSetText("S3 " + Ls_12 + " Label " + Ai_0, "S3 " + Ls_12 + ": " + DoubleToStr(Gd_216, G_digits_260), pivotFontSize, pivotFont, S3Color);
}
	 	 	  			   	  			 	 		  	 	 		 		 		    			    		   	 		 	   		 	  		 			 	  		 	  				 			   	     	 	 	 		  	    	 			    	  	 			   	  	 	  
void clearBars(int Ai_0) {
   string Ls_4;
   if (weeklyNotDaily) Ls_4 = "Week";
   else Ls_4 = "Day";
   if (showPivotIcons) {
      ObjectDelete("P " + Ls_4 + " Icon " + Ai_0);
      ObjectDelete("R1 " + Ls_4 + " Icon " + Ai_0);
      ObjectDelete("R2 " + Ls_4 + " Icon " + Ai_0);
      ObjectDelete("R3 " + Ls_4 + " Icon " + Ai_0);
      ObjectDelete("S1 " + Ls_4 + " Icon " + Ai_0);
      ObjectDelete("S2 " + Ls_4 + " Icon " + Ai_0);
      ObjectDelete("S3 " + Ls_4 + " Icon " + Ai_0);
   }
   if (showPivotLabels) {
      ObjectDelete("P " + Ls_4 + " Label " + Ai_0);
      ObjectDelete("R1 " + Ls_4 + " Label " + Ai_0);
      ObjectDelete("R2 " + Ls_4 + " Label " + Ai_0);
      ObjectDelete("R3 " + Ls_4 + " Label " + Ai_0);
      ObjectDelete("S1 " + Ls_4 + " Label " + Ai_0);
      ObjectDelete("S2 " + Ls_4 + " Label " + Ai_0);
      ObjectDelete("S3 " + Ls_4 + " Label " + Ai_0);
   }
}